/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigDigester;
import com.ibm.hwmca.ui.bonsai.config.WuiConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.earth.TreeNodeIdManager;
import com.ibm.hwmca.ui.bonsai.servlet.Action;
import com.ibm.hwmca.ui.bonsai.servlet.util.ActionUtils;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorManager;
import com.ibm.psw.reuse.gen.RuNlsBundleCache;
import com.ibm.psw.reuse.web.RuWASServiceability;
import com.ibm.psw.uil.ras.IUilServiceability;
import com.ibm.psw.uil.ras.IUilServiceabilityProvider;
import com.ibm.psw.uil.ras.UilServiceabilityContextCache;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.page.IPageManager;
import com.ibm.psw.wcl.core.page.PageException;
import com.ibm.psw.wcl.core.page.PageManager;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.RendererInfo;
import com.ibm.psw.wcl.core.renderer.output.IDocumentOutput;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.trigger.IResult;
import com.ibm.psw.wcl.core.trigger.RequestNotHandledException;
import com.ibm.psw.wcl.core.trigger.TriggerException;
import com.ibm.psw.wcl.tags.core.WJspPage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ControllerServlet
extends HttpServlet
implements IUilServiceabilityProvider {
    static final long serialVersionUID = -5332287525923253726L;
    private RuWASServiceability ras_;
    private UilServiceabilityContextCache contextCache_ = new UilServiceabilityContextCache();
    private HashMap _actions;
    private WuiConfigBean configBean_ = null;
    private static UIObjectsReader uiObjectsReader = null;
    private static final RuNlsBundleCache NBC_ = new RuNlsBundleCache();
    public static final String FACADE_ID_ATTRIBUTE = "facadeid";
    public static final String CONTEXT_ATTRIBUTE = "contextpath";
    public static final String ACTIONCLASSES_ID_ATTRIBUTE = "actionclasses";
    private static final String VR = "1.0";
    private static final String RB = (class$com$ibm$hwmca$ui$bonsai$util$BonsaiResources == null ? (class$com$ibm$hwmca$ui$bonsai$util$BonsaiResources = ControllerServlet.class$("com.ibm.hwmca.ui.bonsai.util.BonsaiResources")) : class$com$ibm$hwmca$ui$bonsai$util$BonsaiResources).getName();
    private static final String ATTR_NLSBUNDLE = "nlsbundle";
    private static final String ATTR_NLSCACHE = "nlscache";
    private static final String TRIGGER_MANAGER_PATH = "/action/";
    private static final String TRACE_MASKT = "XBNCTRLT";
    private static final String TRACE_MASKF = "XBNCTRLF";
    private static final String TRACE_MASKD = "XBNCTRLD";
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$util$BonsaiResources;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.initActionClasses(config);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
            throw new ServletException("Error initializing the web application.", (Throwable)e);
        }
    }

    public final void destroy() {
        super.destroy();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block18: {
            Trace.trace(TRACE_MASKT, "-> ControllerServlet.doGet()");
            try {
                IOutput ioOutput;
                ServletRuntime.getRuntime().attachUserContextToServletThread(request);
                HttpSession session = request.getSession(true);
                HMCSession hmcSession = HMCSession.getHMCSession(request.getSession());
                if (hmcSession == null) {
                    throw new IllegalStateException("No HMC Session");
                }
                if (UISession.getUISession(hmcSession) == null) {
                    try {
                        new UISession().init(hmcSession);
                    }
                    catch (Exception ex) {
                        throw new ServletException("Could not initialize UISession! " + ex.toString());
                    }
                }
                session.setAttribute(ATTR_NLSBUNDLE, (Object)RB);
                session.setAttribute(ATTR_NLSCACHE, (Object)NBC_);
                if (null == this.configBean_) {
                    this.createGlobalObjects();
                }
                WclFacade facade = this.getFacade(request, session);
                TriggerContext tc = facade.createTriggerContext(request, this.getServletContext());
                RenderingContext rc = facade.createRenderingContext(request, response, this.getServletContext());
                rc.setRendererInfo(RendererInfo.HTML_ALL);
                if (facade.canHandleRequest(tc)) {
                    this.handleTrigger(request, response, facade, rc, tc);
                    break block18;
                }
                String actionName = this.getActionFromURI(request);
                if (null == actionName) {
                    response.sendError(406);
                    return;
                }
                Action actionClass = (Action)this._actions.get(actionName);
                if (null == actionClass) {
                    response.sendError(501);
                    return;
                }
                WPage outputPage = actionClass.perform(this, request, response, rc);
                if (outputPage == null) break block18;
                try {
                    ioOutput = outputPage.getOutput(rc);
                    facade.saveAllPages((AContext)rc);
                }
                catch (RendererException e) {
                    throw new ServletException("Error getting Frameset output to render.", (Throwable)e);
                }
                catch (PageException pe) {
                    throw new ServletException("Error serializing output for Frameset.", (Throwable)pe);
                }
                response.setContentType("text/html; charset=UTF-8");
                if (!response.containsHeader("Pragma")) {
                    response.setHeader("Pragma", "no-cache");
                }
                if (!response.containsHeader("Cache-Control")) {
                    response.setHeader("Cache-Control", "no-store");
                }
                if (!response.containsHeader("Expires")) {
                    response.setHeader("Expires", "0");
                }
                PrintWriter respOut = response.getWriter();
                try {
                    ((IDocumentOutput)ioOutput).serializeDocument((Writer)respOut);
                }
                catch (RendererException e) {
                    throw new ServletException("Error serializing output for Frameset.", (Throwable)e);
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                throw new ServletException("Error in doGet", (Throwable)e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- ControllerServlet.doGet()");
    }

    private void handleTrigger(HttpServletRequest request, HttpServletResponse response, WclFacade facade, RenderingContext rc, TriggerContext tc) throws ServletException, IOException {
        block15: {
            try {
                IResult result = facade.handleRequest(tc, rc);
                if (result != null) {
                    try {
                        if (result.isResponseHandled()) break block15;
                        IOutput output = result.getOutput(rc);
                        if (output instanceof IDocumentOutput) {
                            response.setContentType("text/html; charset=UTF8");
                            if (!response.containsHeader("Pragma")) {
                                response.setHeader("Pragma", "no-cache");
                            }
                            if (!response.containsHeader("Cache-Control")) {
                                response.setHeader("Cache-Control", "no-store");
                            }
                            if (!response.containsHeader("Expires")) {
                                response.setHeader("Expires", "0");
                            }
                            PrintWriter respOut = response.getWriter();
                            ((IDocumentOutput)output).serializeDocument((Writer)respOut);
                        } else {
                            WComponent comp = result.getComponent();
                            if (comp instanceof WJspPage) {
                                WJspPage page = (WJspPage)comp;
                                String url = page.getURL();
                                ActionUtils.forward((ServletRequest)request, (ServletResponse)response, url);
                            }
                        }
                        break block15;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.out);
                        throw ex;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                        response.sendError(500, "Unexpected exception caught:" + ex.getMessage());
                        break block15;
                    }
                }
                response.sendError(500, "The trigger did not return a result.");
            }
            catch (TriggerException te) {
                te.printStackTrace(System.out);
                throw new ServletException((Throwable)te);
            }
            catch (RequestNotHandledException rnhe) {
                rnhe.printStackTrace(System.out);
                throw new ServletException((Throwable)rnhe);
            }
        }
        try {
            facade.saveAllPages((AContext)rc);
        }
        catch (PageException pe) {
            pe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WclFacade getFacade(HttpServletRequest request, HttpSession session) {
        WclFacade facade = (WclFacade)ActionUtils.getFromSession(request, FACADE_ID_ATTRIBUTE);
        if (facade == null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                facade = new WclFacade("/bonsai/action/");
                PageManager pm = new PageManager("s", false, false);
                facade.setPageManager((IPageManager)pm, (AContext)facade.createTriggerContext(request, this.getServletContext()));
                ActionUtils.putToSession(request, FACADE_ID_ATTRIBUTE, facade);
            }
        }
        return facade;
    }

    private void createGlobalObjects() throws Exception {
        this.configBean_ = BonsaiConfigDigester.getConfigData();
        uiObjectsReader = new UIObjectsReader();
        TreeNodeIdManager.init();
        TaskManager.init(this.configBean_.getTaskRetrievers());
        BonsaiTreeManager.init(this.configBean_.getNavArea());
        StatusMonitorManager.init(this.configBean_.getStatusMonitors());
    }

    private void initActionClasses(ServletConfig config) throws Exception {
        this._actions = new HashMap();
        String actionName = null;
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            actionName = (String)e.nextElement();
            this._actions.put(actionName, Class.forName(this.getInitParameter(actionName)).newInstance());
        }
    }

    private String getActionFromURI(HttpServletRequest request) {
        String path = request.getServletPath();
        int slash = path.lastIndexOf("/");
        int period = path.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            path = path.substring(0, period);
        }
        return path;
    }

    public final IUilServiceability getServiceability() {
        return (IUilServiceability)this.getServletContext().getAttribute("showSVC");
    }

    public final boolean isServiceabilityActive() {
        IUilServiceability ras = this.getServiceability();
        return ras != null && ras.isServiceabilityActive();
    }

    public final boolean isServiceabilityAvailable() {
        return false;
    }

    public static UIObjectsReader getUIObjectsReader() {
        if (uiObjectsReader == null) {
            throw new IllegalStateException("The global reader has not yet been initialized!");
        }
        return uiObjectsReader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

